<?php

namespace Osteo_Accordion;
defined( 'ABSPATH' ) || die();

if ( !class_exists( 'Assets_Manager' ) ) {

    class Assets_Manager {

        private static $_instance = null;
        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        public function __construct() {
            add_action( "elementor/frontend/after_enqueue_styles", [$this, 'frontend_enqueue_styles'] );
            add_action( 'elementor/frontend/after_enqueue_scripts', [$this, 'frontend_enqueue_scripts'] );
        }

        public function frontend_enqueue_styles() {

            wp_enqueue_style( 'acc', OSTEO_ACCORDION_ASSETS . 'vendor/accordion/css/style.css', array(), '1.0.0' );
            wp_enqueue_style( 'osteo-accordion-style', OSTEO_ACCORDION_ASSETS . 'css/style.css', array(), '1.0.0' );

        }

        public function frontend_enqueue_scripts() {

            wp_enqueue_script( 'acc', OSTEO_ACCORDION_ASSETS . 'vendor/accordion/js/acc.js', array( 'jquery' ), '1.0.0', true );

        }

    }

    Assets_Manager::instance();

}